from tabular_data import Table
import datetime

##def collect_info(list_of_info_to_collect,**kwargs):
##    for n in list_of_info:
        
class order:
    def __init__(self,cart,delivery_date):
        self._order_date=datetime.datetime.today()
        self._products=cart._products
        self._delivery_date=delivery_date
    def __str__(self):
        time_details='Order Date: '+self._order_date.strftime('%A %d %B %Y')
        t=Table(['Product Name', 'Product Price'],\
                    [p.name for p in self._products],\
                    [p.price for p in self._products])
        total=sum([p._price for p in self._products])
        duration = self._delivery_date-datetime.datetime.today()#Note we want today's date not order_date
        delivery_time=self._delivery_date.time().strftime('%I:%M %p')#format is 'hours:minutes am/pm'
        delivery_info='Your delivery is due in '+str(duration.days)+\
                       ' days and should be picked up (or delivered) at '+delivery_time
        return time_details+'\n'+str(t)+'\n'+'Total: '+str(total)+'\n'+delivery_info
        #each part of the string should be displayed on a new line

class CheckoutException(ValueError):
    pass

class payment:

    #Consturctor where user passing in all details at time of construction
    def __init__(self,customer_name,card_type,card_number,card_expiry,pin):
        self._payment_date=datetime.datetime.today()
        self._customer_name=self.validate(customer_name,'str',size=30)
        self._card_type=self.validate(card_type,'card',size=20)
        self._card_number=self.validate(card_number,'int',size=9)
        self._card_expiry=self.validate(card_expiry,'date',date_format='%m/%y')
        try:
            self._pin=self.validate(pin,'int',size=4)
        except ValueError:
            raise CheckoutException('The pin number should be 4 digits') from None

    #Interactive constructor that prompts for the details
    @classmethod
    def interative_payment(cls):
        return cls(cls.get_customer_name(),
                   cls.get_card_type(),
                   cls.get_card_number(),
                   cls.get_card_expiry(),
                   cls.get_pin())
        
    #methods for getting manual input
    @classmethod
    def get_customer_name(self):
        customer_name = input('Please enter the name on your credit card: ')
        return customer_name
    @classmethod
    def get_card_type(self):
        card_type = input ('Please enter the type of credit card: ')
        return card_type
    @classmethod
    def get_card_number(self):
        card_number = input ('Please enter the credit card number: ')
        return card_number
    @classmethod
    def get_card_expiry(self):
        card_expiry = input ('Please enter the expiry date of credit card (mm/yy): ')
        return card_expiry
    @classmethod
    def get_pin(self):
        pin = input ('Please enter the pin: ')
        return pin

    #Method to convert payment to string
    def __str__(self):
        return 'Name: '+str(self._customer_name)+'\n'\
               +'Type of card: '+str(self._card_type)+'\n'\
               +'Card number: '+str(self._card_number)+'\n'\
               +'Expiry: '+datetime.datetime.strftime(self._card_expiry,'%m/%y')+'\n'\
               +'Pin: '+str(self._pin)
        
    #validation methods
    def validate(self,input,datatype,**kwargs):
        #check length
        if kwargs.get('size'):#if size is one of the keyword args
            if len(str(input)) > int(kwargs.get('size')):
                raise CheckoutException('Input must not be more than '+str(kwargs.get('size'))+\
                      ' characters')
            if len(str(input)) ==0:
                raise CheckoutException('You must enter a value for this field')
        #check specifics for differnt types
        if datatype=='int':
            return int(input)
        if datatype=='date':
            try:
                return datetime.datetime.strptime(input,kwargs.get('date_format'))
            except ValueError as ve:
                raise CheckoutException(str(ve.args)) from None
        if datatype=='card':
            if input not in ['Visa','Master Card']:
                raise CheckoutException('Sorry we only accept Visa or Mastercard payments')
                
        #if we get this far then data is valid and a string
        #could use an assert statement here to check this.
        assert isinstance(input,str)
        return input 
            
class checkout:
    def __init__(self,shopping_cart):
        self._shopping_cart=shopping_cart

    def place_order(self):

        #ask for pickup date and time     
        date = input('Please enter your pickup/delviery date (DD/MM/YY): ')
        time = input('Please enter your pickup/devlivery time (HH:MM AM/PM): ')
        delivery_date=datetime.datetime.strptime(date+' '+time, '%d/%m/%y %I:%M %p')
        current_order = order(self._shopping_cart,delivery_date)
        print('Your new delivery date and time is: '+\
              datetime.datetime.strftime(current_order._delivery_date, '%d/%m/%y %I:%M %p'))

        #Cofirm date and time
        response = input("Please confirm you wish to proceed? Yes / Change Date/ Cancel: ")
        while response == 'Change Date':
            date = input('Please enter your pickup/delviery date (DD/MM/YY): ')
            time = input('Please enter your pickup/devlivery time (HH:MM AM/PM): ')
            delivery_date=datetime.datetime.strptime(date+' '+time, '%d/%m/%y %I:%M %p')
            current_order._delivery_date=delivery_date
            print('Your new delivery date and time is: '+\
                  datetime.datetime.strftime(current_order._delivery_date, '%d/%m/%y %I:%M %p'))
            response = input("Please confirm you wish to proceed? Yes / Change Date/ Cancel: ")
        if response == "Cancel":
            raise CheckoutException("Order cancelled by operator")
        
	#ask for customer information (delivery address, etc)
        address = input ('Please enter your address: ')

        #ask for credit card details
        current_payment=payment.interative_payment()

        #validate payment

        #finish the order
        print("Order Confirmed. ")
        print("Thank you for shopping with us.")
        print("We look forward to seeing you again soon.")
        print(current_order)
        
class Response():
    def __init__(self,function):
        if callable(function):
            self._function=function
        else:
            raise TypeError('Objects passed to Response must be callable')

    def __enter__(self):
        self._response = "none"
        return self #return this response object so we can interact with it.
    
    def __exit__(self,exc_type,exc_val,exc_tb):
        self._response = input("Please confirm you wish to proceed? "\
                               +"yes/no/change: ")
        if self._response == "change":
            with Response(self._function):
                return self._function()
        if self._response == "no":
            raise CheckoutException("Cancelled by operator")
        if self._response == "yes":
            print("Thank you for your response")
            
    def run(self):
        return self._function()
        
